//Experiment-13
// windows 8.1 - 64-Bit
//Scilab - 6.0.0

//Aim :Computation of winding factor and distribution factor in armature winding using SCILAB programming
//Data:Calculate winding factor and distribution factor for armature winding of synchronous machine

clc;
clear all;

// Data to be taken from the user

p=input('Enter no. of poles') // no. of poles in synchronous machine (in the range of 2 - 12)
s=input('Enter no. of slots') // no. of slots in synchronous machine ( in the range of 16 - 96)
pitch=input('Enter No. of short pitch slots') // no. of slots by which short pitching is required ( in the range of 1 to 4)

// Actual calculations start

sp = s/p // slots per pole
spp = sp/3 // slots per pole per phase
dist = %pi/spp // 
spread = %pi/sp // phase spread angle
alpha = spread*pitch // angle of short pitch
bet = %pi/p // distribution angle 

kp1=cos(alpha/2) // pitch factor for fundamental
kp5=cos(5*alpha/2) // pitch factor for 5th harmonic

kd1=(sin(spp*bet/2))/(spp*sin(bet/2)) // distribution factor for fundamental
kd5=(sin(spp*5*bet/2))/(spp*sin(5*bet/2)) // distribution factor for 5th harmonic

mprintf('Pitch factor for fundamental is %f',kp1)
mprintf('\n')
mprintf('Pitch factor for 5th harmonic is %f',kp5)
mprintf('\n')
mprintf('Distribution factor for fundamental is %f',kd1)
mprintf('\n')
mprintf('Distribution factor for 5th harmonic is %f',kd5)
mprintf('\n')
